using System;
using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for Lock.
	/// </summary>
	public class Lock
	{
		#region Variables 

		private System.Guid _lockedRecordGuid = System.Guid.Empty;
		private System.Guid _sessionGuid = System.Guid.Empty;

		private string _userNTLoginId = string.Empty;
		private static BOL.VbecsUser _lockUser = null;
		private Common.LockFunctions _lockFunctionId = Common.LockFunctions.NA;
        private Common.LockFunctions _lockedUseCase = Common.LockFunctions.NA;
		private System.DateTime _lockCreatedTime = System.DateTime.MinValue;
        private int _lockedFormId = 0;
        private int _baseLockedFormId = 0;

		/// <summary>
		/// This is populated from a LockInsert.  True = Error.  A lock already existed for this record
		/// </summary>
		private bool _lockConflictIndicator = false;

		//By default, we're creating a lock object, because a lock exists
		private bool _lockExists = true;

		#endregion


		#region Constructors

		/// <summary>
		/// Default constructor -- I know we're not supposed to, but still need it for data
		/// I protected it!
		/// </summary>
		internal Lock()
		{
			this._lockExists = false;		//This constructor should only get called if no locks were found, so we set to false
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6783"> 
		///		<ExpectedInput>Valid DataRow</ExpectedInput>
		///		<ExpectedOutput>Lock Object</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6784"> 
		///		<ExpectedInput>Invalid DataRow</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor - passing existing Lock info as datarow
		/// </summary>
		/// <param name="drLock"></param>
		public Lock(System.Data.DataRow drLock)
		{
			this.LoadFromDataRow(drLock);
		}

		#endregion

		#region Methods

		/// <summary>
		/// Loads the Lock Object with data from the DataRow
		/// </summary>
		/// <param name="drData"></param>
		private void LoadFromDataRow(System.Data.DataRow drData)
		{
			if (drData.Table.Columns.Contains(TABLES.VbecsLock.LockedFormId))
			{
                if (!drData.IsNull(TABLES.VbecsLock.LockedFormId))
                {
                    this._lockedFormId = (System.Int32)drData[TABLES.VbecsLock.LockedFormId];
                }
			}

			if (drData.Table.Columns.Contains(TABLES.VbecsLock.SessionGuid))
			{
                if (!drData.IsNull(TABLES.VbecsLock.SessionGuid))
                {

                    this._sessionGuid = (System.Guid)drData[TABLES.VbecsLock.SessionGuid];
                }
			}

            if (drData.Table.Columns.Contains(TABLES.VbecsLock.LastUpdateDate))
            {
                if (!drData.IsNull(TABLES.VbecsLock.LastUpdateDate))
                {

                    this._lockCreatedTime = (System.DateTime)drData[TABLES.VbecsLock.LastUpdateDate];
                }
            }

            if (drData.Table.Columns.Contains(TABLES.VbecsLock.LockFunctionId))
            {
                if (!drData.IsNull(TABLES.VbecsLock.LockFunctionId))
                {
                    this._lockFunctionId = (Common.LockFunctions)drData[TABLES.VbecsLock.LockFunctionId];
                }
            }

            if (drData.Table.Columns.Contains(TABLES.VbecsLock.LastUpdateUser))
            {
                if (!drData.IsNull(TABLES.VbecsLock.LastUpdateUser))
                {
                    this._userNTLoginId = drData[TABLES.VbecsLock.LastUpdateUser].ToString();
                }
            }

            if (drData.Table.Columns.Contains(TABLES.VbecsLock.LockedRecordGuid))
            {
                if (!drData.IsNull(TABLES.VbecsLock.LockedRecordGuid))
                {
                    this._lockedRecordGuid = (System.Guid)drData[TABLES.VbecsLock.LockedRecordGuid];
                }
            }

            if (drData.Table.Columns.Contains(TABLES.VbecsLock.LockedUseCaseId))
            {
                if (!drData.IsNull(TABLES.VbecsLock.LockedUseCaseId))
                {
                    //CVS changed on 3/8/13 to grab the locked use case id from drdata instead of the lockfunctionid
                    this._lockedUseCase = (Common.LockFunctions)drData[TABLES.VbecsLock.LockedUseCaseId];
                }
            }

            if (drData.Table.Columns.Contains(TABLES.VbecsLock.BaseLockedFormId))
            {
                if (!drData.IsNull(TABLES.VbecsLock.BaseLockedFormId))
                {
                    this._baseLockedFormId = (System.Int32)drData[TABLES.VbecsLock.BaseLockedFormId];
                }
            }

            if (drData.Table.Columns.Contains(ARTIFICIAL.LockConflictIndicator))
            {
                if (!drData.IsNull(ARTIFICIAL.LockConflictIndicator))
                {
                    this._lockConflictIndicator = (System.Boolean)drData[ARTIFICIAL.LockConflictIndicator];
                }
            }
        }

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6785"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>boolean</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6786"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Does the lock exist --- this is for UI for code readablility
		/// </summary>
		public bool LockExists
		{
			get
			{
				return(this._lockExists);
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6787"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6788"> 
		///		<ExpectedInput>bad id</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// When trying to lock a locked record, this will be set to TRUE
		/// </summary>
		public bool LockConflictIndicator(int formId)
		{
            if (this.LockExists )
            {
                if (this._lockConflictIndicator)
                {
                    //If a conflict was found, but it's our seession, and formId, then its no contention
                    //we trying to lock the same record twice, which is .. OK (helps w/ locking code fired by multiple events)
                    if (this.LockedFormId == formId && this.SessionGuid == Common.LogonUser.VbecsSessionGuid)
                        return (false);
                }
            }
    		return(this._lockConflictIndicator);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6789"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6790"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Record being locked
		/// </summary>
		public System.Guid LockedRecordGuid
		{
			get
			{
				return(this._lockedRecordGuid);
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6791"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6792"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Unique Identifier of the locking form (needed for UC's that can be OMT)
		/// OMT = Opened Multiple Times
		/// </summary>
		public int LockedFormId
		{
			get
			{
				return(this._lockedFormId);
			}
		}



		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2007</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8468"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8469"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the SessionGuid that was retrieved from the database (vis #ctr(DataRow)
		/// The current value is in Common.LogonUser
		/// </summary>
		public System.Guid SessionGuid
		{
			get
			{
				return(this._sessionGuid);
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6793"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6794"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// NT Id of the locking user
		/// </summary>
		public string UserNTLoginId
		{
			get
			{
				return(this._userNTLoginId);
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6795"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6796"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// User's actual "name" - for displaying messages
		/// </summary>
		public string UserName
		{
			get
			{
				//_lockUser is static to avoid creating multiple users over and over
				if (_lockUser == null)
					_lockUser = new BOL.VbecsUser(this.UserNTLoginId, false);

				//If the current user is different than who has the lock
				if (_lockUser.UserNTLoginID != this.UserNTLoginId)
					_lockUser = new BOL.VbecsUser(this.UserNTLoginId, false);

				return(_lockUser.UserName);
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6797"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6798"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Time the lock was generated
		/// </summary>
		public System.DateTime LockCreatedTime
		{
			get
			{
				return(this._lockCreatedTime);
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6799"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>LockFunctions</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6800"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// UC the lock is for
		/// </summary>
		public Common.LockFunctions LockFunctionId
		{
			get
			{
				return(this._lockFunctionId);
			}
		}


        /// <summary>
        /// LockedUseCase
        /// </summary>
        public Common.LockFunctions LockedUseCase
        {
            get
            {
                return (this._lockedUseCase);
            }
        }

		#endregion
	}
}
